/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.HudRenderedVariableIntPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public class ResourcePower
extends HudRenderedVariableIntPower {
    private final Consumer<Entity> actionOnMin;
    private final Consumer<Entity> actionOnMax;

    public ResourcePower(PowerType<?> type, PlayerEntity player, HudRender hudRender, int startValue, int min, int max, Consumer<Entity> actionOnMin, Consumer<Entity> actionOnMax) {
        super(type, player, hudRender, startValue, min, max);
        this.actionOnMin = actionOnMin;
        this.actionOnMax = actionOnMax;
    }

    @Override
    public int setValue(int newValue) {
        int oldValue = this.currentValue;
        int actualNewValue = super.setValue(newValue);
        if (oldValue != actualNewValue) {
            if (this.actionOnMin != null && actualNewValue == this.min) {
                this.actionOnMin.accept((Entity)this.player);
            }
            if (this.actionOnMax != null && actualNewValue == this.max) {
                this.actionOnMax.accept((Entity)this.player);
            }
        }
        return actualNewValue;
    }
}

